//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define def_KEY_UP          38
#define def_KEY_DOWN        40
//+----------------+
#define macro_NameObject  "Demo" + (string)ObjectsTotal(0)
//+------------------------------------------------------------------+
string  gl_Objs[2];
//+------------------------------------------------------------------+
int OnInit()
{
    ObjectCreate(0, gl_Objs[0] = macro_NameObject, OBJ_VLINE, 0, 0, 0);
    ObjectSetInteger(0, gl_Objs[0], OBJPROP_COLOR, clrRoyalBlue);
    ObjectCreate(0, gl_Objs[1] = macro_NameObject, OBJ_HLINE, 0, 0, 0);
    ObjectSetInteger(0, gl_Objs[1], OBJPROP_COLOR, clrPurple);

    return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
    return rates_total;
};
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
    static int p = 0;
    MqlRates rate[1];

    switch(id)
    {
        case CHARTEVENT_KEYDOWN:
            switch ((int)lparam)
            {
                case def_KEY_DOWN:
                    p = (p < Bars(_Symbol, _Period) ? p + 1 : p);
                    break;
                case def_KEY_UP:
                    p = (p > 0 ? p - 1 : p);
                    break;
                default:
                    return;
            }
            Comment(StringFormat("Current bar analyzed: %d", p));
            CopyRates(_Symbol, _Period, p, rate.Size(), rate);
            ObjectMove(0, gl_Objs[0], 0, rate[0].time, rate[0].close);
            ObjectMove(0, gl_Objs[1], 0, rate[0].time, rate[0].close);
            break;
    }
    ChartRedraw();
};
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
    Comment("");
    for (uint c = 0; c < gl_Objs.Size(); c++)
        ObjectDelete(0, gl_Objs[c]);
    ChartRedraw();
};
//+------------------------------------------------------------------+